class StatsNotify expands SpawnNotify;


simulated event Actor SpawnNotification( Actor A )
{
	local StatsHUD ourHudMut;
	local StatsInfo tmp;

	
	ourHudMut = Spawn(class'DanesStats.StatsHUD', A);
	if (ourHudMut == None)
	{
		log("TheDanes Statistics : failed to spawn the HUD from the StatsNotify class.");
		return A;
	}

	foreach AllActors(class'StatsInfo', tmp)
		ourHudMut.I = tmp;
	if (ourHudMut.I == None)
	{
		log("TheDanes Statistics : StatsNotify class failed to find the StatsInfo class.");
		return A;
	}

	ourHudMut.playerOwner = PlayerPawn(A.Owner);
	if (ourHudMut.playerOwner == None)
	{
		log("TheDanes Statistics : StatsNotify class is unable to set the PlayerOwner");
		return A;
	}

	ourHudMut.FI = Spawn(class'Botpack.FontInfo');
	if (ourHudMut.FI == None) // play thafe
	{
		log("TheDanes Statistics : StatsNotify class failed to link to the FontInfo class");
		return A;
	}

	if (HUD(A).HUDMutator == None)
		HUD(A).HUDMutator = ourHudMut;
	else
		HUD(A).HUDMutator.AddMutator(ourHudMut);

	log("TheDanes Statistics : The mutator has loaded successfully.");

	return A;
}


defaultproperties
{	
	ActorClass=class'Engine.HUD'
	bHidden=True
}
